#!/bin/sh
#
# Copyright (c) 2006-2007 by Made to Order Software Corporation
# All rights reserved
#
# This script installs Turn Watcher on the local system. You can choose
# where to install the application.
#
set -e

# Minimum glibc
MIN_GLIBCMAJOR=2
MIN_GLIBCMINOR=2


check_glibc () {
  ICONV=`iconv --version | sed -e '2,$d'`
  if [ $? -ne 0 ]
  then
    echo "no-iconv"
  else
  #
    ICONVVER=`echo "$ICONV" | awk '{print $4}'`
    GLIBCMAJOR=`echo $ICONVVER | cut -d'.' -f1`
    GLIBCMINOR=`echo $ICONVVER | cut -d'.' -f2`
    #
    if [ \( $GLIBCMAJOR -gt $MIN_GLIBCMAJOR \) ]
    then
      echo "valid-glibc"
    elif [ \( $GLIBCMAJOR -eq $MIN_GLIBCMAJOR \) -a \( $GLIBCMINOR -ge $MIN_GLIBCMINOR \) ]
    then
      echo "valid-glibc"
    else
      echo "invalid-glibc"
    fi
  fi
}


# check for iconv and version of glibc
GLIBCSTATUS=`check_glibc`
case $GLIBCSTATUS in
  invalid-glibc)
    echo "Must have at least glibc 2.3.x!"
    exit 1;
    ;;
esac


# print the license to the user
more <<EOF
		    End-User License Agreement for
       Made to Order Software, Corporation Turn Watcher product

Note: unofficial translations of this license agreement are available
"online".

IMPORTANT - READ CAREFULLY: This Made to Order Software, Corporation
End-User License agreement ("EULA") is a legal agreement between you (either
an individual or a single entity) and Made to Order Software, Corporation
(m2osw) for Turn Watcher, which includes computer software and may include
associated media, printed materials, and "online" or electronic documentation
("Software Product"). The Software Product also includes any updates and
supplements to the original Software Product provided to you by m2osw. Any
software provided along with the Software Product that is associated with a
separate end-user license agreement is licensed to you under the terms of
that license agreement. By installing, copying, downloading, accessing, or
otherwise using the Software Product, you agree to be bound by the terms of
this EULA. If you do not agree to the terms of this EULA, do not install or
use the Software Product; you may, however, return it to your place of
purchase for a full refund.

  Software Product License

The Software Product is protected by copyright laws and international
copyright treaties, as well as other intellectual property laws and treaties.
The Software Product is licensed, not sold.

   1. Grant of License.

      This EULA grants you the following rights:

	a. Applications Software. You may install, use, access, display,
	   run, or otherwise interact with ("Run") one copy of the Software
	   Product, or any prior version for any of the operating system
	   supported by the Software Product, on a single computer,
	   workstation, terminal, handheld PC, pager, "smart phone," or other
	   electronic device ("Computer") at a time. The primary user of the
	   Computer on which the Software Product is installed may make as
	   many copies as necessary on any number of Computers for his or her
	   exclusive use.

	b. Storage/Network Use. You may also store or install copies of the
	   Software Product on a storage device, such as a network server, used
	   only to Run the Software Product on your other Computers over an
	   internal network; however, you must acquire and dedicate a license
	   for each separate Computer on which the Software Product is Run
	   concurrently from the storage device. A single license for the
	   Software Product may not be shared or used concurrently on different
	   Computers.

	c. Reservation of Rights. All rights not expressly granted are
	   reserved by m2osw.

   2. Description of Other Rights and Limitations.

	a. Not for Resale Software. If the Software Product is labeled "Not
	   For Resale" or "Demo Software", then, notwithstanding other sections
	   of this EULA, your use of the Software Product is limited to use for
	   demonstration, test, or evaluation purposes and you may not resell,
	   or otherwise transfer for value, the Software Product.

	b. Limitations on Reverse Engineering, Decompilation, and
	   Disassembly. You may not reverse engineer, decompile, or disassemble
	   the Software Product, except and only to the extent that such
	   activity is expressly permitted by applicable law notwithstanding
	   this limitation.

	c. Separation of Components. The Software Product is licensed as a
	   single product. Its component parts may not be separated for use on
	   more than one Computer at a time. Some parts of the Software Product
	   come from open source projects ("OSP"). The code and components of
	   these OSP can be obtained separately and used freely notwithstanding
	   this limitation.

	d. Trademarks. This EULA does not grant you any rights in connection
	   with any trademarks or service marks of m2osw.

	e. Rental. This license does not grant you any right to rent, lease,
	   or lend the Software Product. m2osw has other licenses available for
	   this purpose.

	f. Support Services. m2osw may provide you with support services
	   related to the Software Product ("Support Services"). Use of Support
	   Services is governed by the m2osw policies and programs described in
	   "online" documentation, and/or in other m2osw provided materials.
	   Any supplemental software code provided to you as part of the
	   Support Services shall be considered part of the Software Product
	   and subject to the terms and conditions of this EULA unless the
	   software code is part of an OSP, in which case it will have its own
	   license. With respect to technical information you provide to m2osw
	   as part of the Support Services, m2osw may use such information for
	   its business purposes, including for product support and
	   development. m2osw will not utilize such technical information in a
	   form that personally identifies you.

	g. Software Transfer. The current licensee of the Software Product
	   may make a one-time permanent transfer of this EULA and Software
	   Product to another user (either an individual or a single entity).
	   This transfer must include all of the Software Product (including
	   all component parts, the media, backup copies thereof, printed
	   materials, any upgrades, and this EULA). Such transfer may not be by
	   way of consignment or any other indirect transfer. The transferee of
	   such one-time transfer must agree to comply with the terms of this
	   EULA. The transferor must destroy all copies of the Software Product
	   that cannot be transferred (such as, but not limited, to the copies
	   on the transferor Computers) at the time the transfer occurs.

	h. Termination. Without prejudice to any other rights, m2osw may
	   terminate this EULA if you fail to comply with the terms and
	   conditions of this EULA. In such event, you must destroy all copies
	   of the Software Product and all of its component parts.

   3. Upgrades.

      If the Software Product is labeled as an upgrade, you must be properly
      licensed to use a product identified by m2osw as being eligible for the
      upgrade in order to use the Software Product. A Software Product
      labeled as an upgrade replaces and/or supplements (and may disable) the
      product that formed the basis for your eligibility for the upgrade. You
      may use the resulting upgraded product only in accordance with the
      terms of this EULA. If the Software Product is an upgrade of a
      component of a package of software programs that you licensed as a
      single product, the Software Product may be used and transferred only
      as part of that single product package and may not be separated for use
      on more than one Computer at a time.

   4. Copyright.

      All title and copyrights in and to the Software Product (including but
      not limited to any images, photographs, animations, video, audio,
      music, text, and "extension modules" incorporated into the Software
      Product), the accompanying printed materials, and any copies of the
      Software Product are owned by m2osw or its suppliers. All title and
      intellectual property rights in and to the content that may be accessed
      through use of the Software Product is the property of the respective
      content owner and may be protected by applicable copyright or other
      intellectual property laws and treaties. This EULA grants you no rights
      to use such content. If this Software Product contains documentation
      that is provided only in electronic form, you may print multiple copies
      of such electronic documentation for your own purpose.  You may not
      copy the printed materials accompanying the Software Product.

   5. Software in Multiple Mediums.

      You may receive the Software Product in more than one medium.
      Regardless of the type or size of mediums you receive, you may use only
      one medium that is appropriate for the Computer on which you are
      currently Running the Software Product. You may not loan, rent, lease,
      or otherwise transfer the other mediums to another user, except as part
      of the permanent transfer (as provided above) of the Software Product.

   6. Backup Copies.

      You may keep the original media on which the Software Product was
      provided by m2osw solely for backup or archival purposes. You may make
      backup copies of the original media solely for backup or archival
      purposes. You will either destroy or transfer all of these copies as
      part of a permanent transfer (as provided above) of the Software
      Product. Except as expressly provided in this EULA, you may not
      otherwise make copies of the Software Product or the printed materials
      accompanying the Software Product.

   7. U.S. Government Restricted Rights.

      All Software Product provided to the U.S. Government pursuant to
      solicitations issued on or after December 1, 1995 is provided with the
      commercial rights and restrictions described elsewhere herein. All
      Software Products provided to the U.S. Government pursuant to
      solicitations issued prior to December 1, 1995 is provided with
      Restricted Rights as provided in FAR, 48 CFR 52.227-14 (June 1987) or
      FAR, 48 CFR 252.227-7013 (October 1988), as applicable.

   8. Export Restrictions.

      You agree that you will not export or re-export the Software Product,
      any part thereof, or any process or service that is the direct product
      of the Software Product (the foregoing collectively referred to as the
      "Restricted Components"), to any country, person or entity subject to
      U.S. export restrictions. You specifically agree not to export or
      re-export any of the Restricted Components (i) to any country to which
      the U.S. has embargoed or restricted the export of goods or services,
      which currently include, but are not necessarily limited to Cuba, Iran,
      Libya, North Korean, Sudan and Syria, or to any national of any such
      country, wherever located, who intends to transmit or transport the
      Restricted Components back to such country; (ii) to any person or
      entity who you know or have reason to know will utilize the Restricted
      Components in the design, development or production of nuclear,
      chemical or biological weapons; or (iii) to any person or entity who
      has been prohibited from participating in U.S. export transactions by
      any federal agency of the U.S. government. You warrant and represent
      that neither the BXA nor any other U.S. federal agency has suspended,
      revoked or denied your export privileges.

   9. No fault tolerant guarantee.

      The Software Product is not fault tolerant and is not designed,
      manufactured, or intended for use or resale as on-line control
      equipment in hazardous environments requiring fail-safe performance,
      such as in the operation of nuclear facilities, aircraft navigation or
      communication systems, air traffic control, in which the failure of our
      Software Product could lead directly to death, personal injury, or
      severe physical or environmental damage.

  10. Laws governing the EULA.

      If you acquired this Software Product in the United States, this EULA
      is governed by the laws of the State of California. If this Software
      Product was acquired outside the United States, then local law may
      apply.

  11. Limited Warranty.

      m2osw warrants that (a) the Software Product will perform substantially
      in accordance with the accompanying written materials for a period of
      ninety (90) days from the date of receipt, and (b) any Support Services
      provided by m2osw shall be substantially as described in applicable
      written materials provided to you by m2osw, and m2osw support engineers
      will make commercially reasonable efforts to solve any problem issues.
      Some states and jurisdictions do not allow limitations on duration of
      an implied warranty, so the above limitation may not apply to you. To
      the extent allowed by applicable law, implied warranties on the
      Software Product, if any, are limited to ninety (90) days.

  12. Customer Remedies.

      m2osw and its suppliers' entire liability and your exclusive remedy
      shall be, at m2osw option, either (a) return of the price paid, if any,
      or (b) repair or replacement of the Software Product that does not meet
      m2osw's limited warranty and which is returned to m2osw with a copy of
      your receipt. This Limited Warranty is void if failure of the Software
      Product has resulted from accident, abuse, or misapplication. Any
      replacement Software Product will be warranted for the remainder of the
      original warranty period or thirty (30) days, whichever is longer.
      Outside the United States, neither these remedies nor any product
      Support Services offered by m2osw are available without proof of
      purchase from an authorized supplier.

  13. No Other Warranties.

      To the maximum extent permitted by applicable law, m2osw and its
      suppliers disclaim all other warranties and conditions, either express
      or implied, including, but not limited to, implied warranties of
      merchantability, fitness for a particular purpose, title, and
      non-infringement, with regard to the software product, and the
      provision of or failure to provide Support Services. This limited
      warranty gives you specific legal rights. You may have others, which
      vary from state/jurisdiction/country to state/jurisdiction/country.

  14. Limitations of Liability.

      To the maximum extent permitted by applicable law, in no event shall
      m2osw or its suppliers be liable for any special, incidental, indirect,
      or consequential damages whatsoever (including, without limitation,
      damages for loss of business profits, business interruption, loss of
      business information, or any other pecuniary loss) arising out of the
      use of or inability to use the Software Product or the provision of or
      failure to provide Support Services, even if m2osw has been advised of
      the possibility of such damages. In any case, m2osw's entire liability
      under any provision of this EULA shall be limited to the greater of the
      amount actually paid by your for the Software Product or U.S. $5.00;
      provided that if you have also entered into a different agreement with
      m2osw, the terms of that other agreement may prevail. Because some
      states, jurisdictions and countries do not allow the exclusion or
      limitation of liability, this limitation may not apply to you.
EOF

read -p "Do you accept our license? (yes/no) " answer
if test "$answer" != "yes"
then
	echo
	echo "WARNING: Installation aborted. The license was refused."
	echo
	exit 1
fi


# In case someone starts the script from outside the folder
cd `dirname $0`

ROOTDIR=`pwd`
INSTDIR=${ROOTDIR}/usr

BINDIR=${INSTDIR}/bin
LIBDIR=${INSTDIR}/lib
GTKDIR=${LIBDIR}/mo/1.3.0
ETCDIR=${GTKDIR}/etc
ETCGTKDIR=${ETCDIR}/gtk-2.0
ETCPANGODIR=${ETCDIR}/pango
GTKBINDIR=${GTKDIR}/bin
GTKLIBDIR=${GTKDIR}/lib
GTKDATADIR=${GTKLIBDIR}/gtk-2.0/2.10.0
GTKIMMODULESDIR=${GTKDATADIR}/immodules
GTKLOADERSDIR=${GTKDATADIR}/loaders
GTKPANGODIR=${GTKLIBDIR}/pango/1.6.0/modules

export LD_LIBRARY_PATH=${GTKDIR}/lib

mkdir -p ${ETCGTKDIR} ${ETCPANGODIR}
${GTKBINDIR}/gtk-query-immodules-2.0	${GTKIMMODULESDIR}/*.so	> ${ETCGTKDIR}/gtk.immodules
${GTKBINDIR}/gdk-pixbuf-query-loaders	${GTKLOADERSDIR}/*.so	> ${ETCGTKDIR}/gdk-pixbuf.loaders
${GTKBINDIR}/pango-querymodules		${GTKPANGODIR}/*.so	> ${ETCPANGODIR}/pango.modules

if test -x /usr/bin/update-menus
then
        /usr/bin/update-menus
fi


sed -e "s%prefix=.*%prefix=${INSTDIR}%" ${BINDIR}/turnwatcher >turnwatcher
chmod a+x turnwatcher

if test -x /usr/bin/x-www-browser
then
	# Under Debian we use the user favorite browser in an automated fashion
	## (though people are likely to use the .deb in this case!)
	if test ! -x usr/bin/turnwatcher-browser
	then
		ln -fs /usr/bin/x-www-browser usr/bin/turnwatcher-browser
	fi
else
	# Under other systems there is not really any default like in Debian
	## (that we know of)
	if test ! -x turnwatcher-browser -a ! -x usr/bin/turnwatcher-browser
	then
		## 65 chars to make sure we stay in the screen.
		echo "================================================================="
		echo "This installation script is about to create a softlink to your"
		echo "favorite browser. To do so, you need to specify the full path"
		echo "to your favorite browser. For instance:"
		echo
		echo "   /usr/bin/firefox"
		echo
		echo "If you want to let Turn Watcher select automatically or if you"
		echo "need to check the name first, hit enter without any name."
		echo "Later you can create the link using the following commands:"
		echo
		echo "   cd `pwd`"
		echo "   ln -fs /usr/bin/firefox turnwatcher-browser"
		echo
		echo "by replacing '/usr/bin/firefox' by the full path to your"
		echo "favorite browser."
		echo
		echo "Please enter the full path of your prefered browser: "
		read browser
		if test -n "$browser"
		then
			ln -fs ${browser} turnwatcher-browser
		fi
	fi
fi

echo
echo "Thank you for installing Turn Watcher."
echo

